#include "POF/User_Parameter.h"

void init_userparameter(struct User_parameter** p_user_parameter) {
	std::unique_ptr<User_parameter> new_p_user_parameter(new User_parameter);
	*p_user_parameter = new_p_user_parameter.release();
}

void print_userparameter(struct User_parameter* user_parameter) {
	cout<<user_parameter->n_rank<<endl;
	cout<<user_parameter->context[0][0]<<endl;
}

void set_userparameter(
	int n_rank,
	double th,
	double beta,
	double min_loss,
	double lambda,
	double xi,
	double context_list[],
	struct User_parameter* user_parameter
) {
	cout<<"start set_userparameter"<<endl;
	cout<<n_rank<<endl;
	
	user_parameter->n_rank = n_rank;
	user_parameter->th = th;
    user_parameter->beta = beta;
	user_parameter->min_loss = min_loss;
    user_parameter->lambda = lambda;
    user_parameter->xi = xi;
    for (int i = 0; i < n_label*n_rank; i++) {
        user_parameter->context[i / n_rank][i % n_rank] = context_list[i];
    }
	
	cout<<user_parameter->n_rank<<endl;
	cout<<user_parameter->context[0][0]<<endl;
}

void update_xi(
	double xi,
	struct User_parameter* user_parameter
) {
	user_parameter->xi = xi;
}

void update_min_loss(
	double min_loss,
	struct User_parameter* user_parameter
) {
	user_parameter->min_loss = min_loss;
}